// Configuración para AsesistelTracker Dashboard
const CONFIG = {
  // URL del iframe para incrustar la aplicación Angular
  ANGULAR_APP_URL: 'http://gps.carabobo.app:8082',
  
  // URLs alternativas para diferentes entornos
  URLS: {
    development: 'http://127.0.0.1:4200',
    production: 'http://localhost:3000',
    cloud: 'https://tu-dominio.com'
  },
  
  // Configuración del dashboard
  DASHBOARD: {
    title: 'AsesistelTracker Dashboard',
    version: '1.0.0',
    company: 'Asesistel',
    refreshInterval: 30000, // 30 segundos
    autoRefresh: true
  },
  
  // Configuración de la aplicación
  APP: {
    theme: 'light', // light | dark
    language: 'es',
    timezone: 'America/Caracas'
  },
  
  // Configuración del iframe
  IFRAME: {
    allowFullscreen: true,
    sandbox: 'allow-same-origin allow-scripts allow-forms allow-popups allow-modals',
    loading: 'eager'
  }
};

// Función para obtener la URL actual según el entorno
function getCurrentEnvironmentURL() {
  const hostname = window.location.hostname;
  
  if (hostname === '127.0.0.1' || hostname === 'localhost') {
    return CONFIG.URLS.development;
  } else {
    return CONFIG.URLS.production;
  }
}

// Exportar configuración para uso global
window.CONFIG = CONFIG;