{* 
 *  @author    DeoTemplate <deotemplate@gmail.com>
 *  @copyright by DeoTemplate
 *  @license   http://deotemplate.com - prestashop template provider
*}

{extends file=$layout}

{block name='content'}
	<section id="main">
		{capture name=path}{l s='Products Comparison' mod='deotemplate'}{/capture}
		<h1 class="page-heading">{l s='Products Comparison' mod='deotemplate'}</h1>
		{if $hasProduct}
			<div class="products_block">
				<table id="product_comparison" class="table table-bordered table-responsive">
					<tr>
						<td class="td_empty compare_extra_information">
							<span>{l s='Features:' mod='deotemplate'}</span>
						</td>
						
						{foreach from=$products item=product name=for_products}
							{assign var='replace_id' value=$product.id|cat:'|'}
							<td class="product-miniature js-product-miniature deo-product-compare-item product-{$product.id_product}" data-id-product="{$product.id_product}" data-id-product-attribute="{$product.id_product_attribute}" itemscope itemtype="http://schema.org/Product">
								
								<div class="thumbnail-container clearfix">
									<div class="delete-productcompare clearfix">
										<a class="deo-compare-button btn delete" href="javascript:voild()" title="{l s='Remove from Compare' mod='deotemplate'}" data-id-product="{$product.id_product}"><i class="deo-custom-icons"></i>
										</a>
									</div>
									<div class="product-image">
										{assign var='second_image' value='0'}
										{assign var='labelflag' value='newsale'}
										{assign var='deo_size' value='home_default'}
										{assign var='deo_size' value='home_default'}
										{assign var='deo_lazyload' value=false}
										{include file="module:deotemplate/views/templates/hook/products/product_thumbnail.tpl"}
									</div>
									<div class="product-meta">							
										{block name='product_name'}
											<h3 class="h3 product-title" itemprop="name"><a href="{$product.url}" title="{$product.name}" target="_blank">{$product.name}</a></h3>
										{/block}
										{include file="module:deotemplate/views/templates/hook/products/product_price_and_shipping.tpl"}
										{hook h='displayDeoCartCombination' product=$product}
										{hook h='displayDeoCartQuantity' product=$product}
										{hook h='displayDeoCartButton' product=$product}	
									</div>
								</div>
							</td>
						{/foreach}
					</tr>
					{if $ordered_features}
						{foreach from=$ordered_features item=feature}
							<tr>
								{cycle values='comparison_feature_odd,comparison_feature_even' assign='classname'}
								<td class="{$classname} feature-name" >
									<strong>{$feature.name|escape:'html':'UTF-8'}</strong>
								</td>
								{foreach from=$products item=product name=for_products}
									{assign var='product_id' value=$product.id}
									{assign var='feature_id' value=$feature.id_feature}
									{if isset($product_features[$product_id])}
										{assign var='tab' value=$product_features[$product_id]}
										<td class="{$classname} comparison_infos product-{$product.id}">{if (isset($tab[$feature_id]))}{$tab[$feature_id]|escape:'html':'UTF-8'}{/if}</td>
									{else}
										<td class="{$classname} comparison_infos product-{$product.id}"></td>
									{/if}
								{/foreach}
							</tr>
						{/foreach}
					{else}
						<tr>
							<td></td>
							<td colspan="{$products|@count}" class="text-center">{l s='No features to compare' mod='deotemplate'}</td>
						</tr>
					{/if}
					{hook h='displayDeoProducReviewCompare' list_product=$list_product}
				</table>
			</div> <!-- end products_block -->
		{else}
			<p class="alert alert-danger">{l s='There are no products selected for comparison.' mod='deotemplate'}</p>
		{/if}
	</section>
{/block}

