{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}

{if $product.add_to_cart_url}
	{assign var="text_btn" value={l s='Add to cart' d='Shop.Theme.Actions'}}
	{assign var="text_title" value={l s='Add to cart' d='Shop.Theme.Actions'}}
{else}
	{if $product.quantity == 0}
		{assign var="text_btn" value={l s='Out of stock' d='Shop.Theme.Actions'}}
		{if count($product.main_variants) <= 1}
			{assign var="text_title" value={l s='Out of stock' d='Shop.Theme.Actions'}}
		{else count($product.main_variants) > 1}
			{assign var="text_title" value={l s='This product available with different options. Please select other combination.' d='Shop.Theme.Actions'}}
		{/if}
	{else if isset($product.embedded_attributes.customization_required) && $product.embedded_attributes.customization_required}
		{assign var="text_btn" value={l s='Add to cart' d='Shop.Theme.Actions'}}
		{assign var="text_title" value={l s='This product have customization required. Please complete the customization field.' d='Shop.Theme.Actions'}}
	{else}
		{assign var="text_btn" value={l s='Add to cart' d='Shop.Theme.Actions'}}
		{assign var="text_title" value={l s='Add to cart' d='Shop.Theme.Actions'}}
	{/if}
{/if}

<div class="product-add-to-cart js-product-add-to-cart">
	{if !$configuration.is_catalog}
		{block name='product_quantity'}
			<div class="product-quantity">
				<div class="qty">
					<div class="qty-content">
						<span class="control-label">{l s='Quantity' d='Shop.Theme.Catalog'}</span>
						<input
							type="number"
							name="qty"
							id="quantity_wanted"
							inputmode="numeric"
							pattern="[0-9]*"
							{if $product.quantity_wanted}
								value="{$product.quantity_wanted}"
								min="{$product.minimal_quantity}"
							{else}
								value="1"
								min="1"
							{/if}							
							class="input-group" 
							aria-label="{l s='Quantity' d='Shop.Theme.Actions'}"
						/>
					</div>
				</div>
				<div class="add">
					<button class="btn btn-outline add-to-cart" data-button-action="add-to-cart" type="submit" data-toggle="deo-tooltip" data-position="top" title="{$text_title}"{if !$product.add_to_cart_url} disabled{/if}>
						<i class="loading-btn-product"></i>
						<i class="deo-custom-icons icon-cart"></i>
						<span class="name-btn-product">{$text_btn}</span>
					</button>
				</div>
				{hook h='displayDeoWishlistButton' product=$product}
				{hook h='displayDeoCompareButton' product=$product}
			</div>
			<div class="clearfix"></div>
			{block name='product_availability'}
				<span id="product-availability" class="js-product-availability">
					{if $product.show_availability && $product.availability_message}
						<span class="{if $product.availability == 'available'}available{elseif $product.availability == 'last_remaining_items'}product-last-items{else}product-unavailable{/if}">
							<i class="deo-custom-icons"></i>
							<span>{$product.availability_message}</span>
						</span>
					{/if}
				</span>
			{/block}
		{/block}

		{block name='product_minimal_quantity'}
			{if $product.minimal_quantity > 1}
				<p class="product-minimal-quantity js-product-minimal-quantity">
					{l
					s='The minimum purchase order quantity for the product is %quantity%.'
					d='Shop.Theme.Checkout'
					sprintf=['%quantity%' => $product.minimal_quantity]
					}
				</p>
			{/if}
		{/block}
	{/if}
</div>
