{**
 * Copyright since 2007 PrestaShop SA and Contributors
 * PrestaShop is an International Registered Trademark & Property of PrestaShop SA
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Academic Free License 3.0 (AFL-3.0)
 * that is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at this URL:
 * https://opensource.org/licenses/AFL-3.0
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to license@prestashop.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PrestaShop to newer
 * versions in the future. If you wish to customize PrestaShop for your
 * needs please refer to https://devdocs.prestashop.com/ for more information.
 *
 * @author    PrestaShop SA and Contributors <contact@prestashop.com>
 * @copyright Since 2007 PrestaShop SA and Contributors
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 *}
{extends file='checkout/_partials/steps/checkout-step.tpl'}

{block name='step_content'}
	{hook h='displayPersonalInformationTop' customer=$customer}

	{if $customer.is_logged && !$customer.is_guest}

		<p class="identity">
			{* [1][/1] is for a HTML tag. *}
			{l s='Connected as [1]%firstname% %lastname%[/1].'
				d='Shop.Theme.Customeraccount'
				sprintf=[
					'[1]' => "<a href='{$urls.pages.identity}'>",
					'[/1]' => "</a>",
					'%firstname%' => $customer.firstname,
					'%lastname%' => $customer.lastname
				]
			}
		</p>
		<p>
			{* [1][/1] is for a HTML tag. *}
			{l
				s='Not you? [1]Log out[/1]'
				d='Shop.Theme.Customeraccount'
				sprintf=[
				'[1]' => "<a href='{$urls.actions.logout}'>",
				'[/1]' => "</a>"
				]
			}
		</p>
		{if !isset($empty_cart_on_logout) || $empty_cart_on_logout}
			<p><small>{l s='If you sign out now, your cart will be emptied.' d='Shop.Theme.Checkout'}</small></p>
		{/if}

		<div class="clearfix">
			<form method="GET" action="{$urls.pages.order}">
				<button
					class="continue btn btn-outline float-sp-right"
					name="controller"
					type="submit"
					value="order"
				>
					{l s='Continue' d='Shop.Theme.Actions'}
				</button>
			</form>

		</div>

	{else}

		<ul class="nav nav-inline tab-account" role="tablist">
			<li class="nav-item">
				<a
					class="nav-link {if !$show_login_form}active{/if}"
					data-toggle="tab"
					href="#checkout-guest-form"
					role="tab"
					aria-controls="checkout-guest-form"
					{if !$show_login_form} aria-selected="true"{/if}
					>
					{if $guest_allowed}
						{l s='Order as a guest' d='Shop.Theme.Checkout'}
					{else}
						{l s='Create an account' d='Shop.Theme.Customeraccount'}
					{/if}
				</a>
			</li>
			<li class="nav-item">
				<a
					class="nav-link {if $show_login_form}active{/if}"
					data-link-action="show-login-form"
					data-toggle="tab"
					href="#checkout-login-form"
					role="tab"
					aria-controls="checkout-login-form"
					{if $show_login_form} aria-selected="true"{/if}
				>
					{l s='Sign in' d='Shop.Theme.Actions'}
				</a>
			</li>
		</ul>

		<div class="tab-content">
			<div class="tab-pane {if !$show_login_form}active{/if}" id="checkout-guest-form" role="tabpanel" {if $show_login_form}aria-hidden="true"{/if}>
				{render file='checkout/_partials/customer-form.tpl' ui=$register_form guest_allowed=$guest_allowed}
				{hook h='displayCustomerLoginFormAfter'}
			</div>
			<div class="tab-pane {if $show_login_form}active{/if}" id="checkout-login-form" role="tabpanel" {if !$show_login_form}aria-hidden="true"{/if}>
				{render file='checkout/_partials/login-form.tpl' ui=$login_form}
				{hook h='displayCustomerLoginFormAfter'}
			</div>
		</div>


	{/if}
{/block}
