<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

use PrestaShop\Module\ProductPriceBySize\Controller\Front\Common\CoreController;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductPriceBySizeAjaxModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        $this->ajax = true;
        parent::initContent();
    }

    public function postProcess()
    {
        $module = Module::getInstanceByName('productpricebysize');
        $productController = new CoreController($module, []);
        switch (Tools::getValue('action')) {
            case 'getProductInfo':
                exit($productController->getProductInfo());
            case 'getPackInfo':
                exit((new PrestaShop\Module\ProductPriceBySize\Controller\Front\Pap\ProductController($module, []))->getPackInfo());
            case 'formatPrice':
                exit(PrestaShop\Module\ProductPriceBySize\Service\FormatterService::formatPrice((float) Tools::getValue('price')));
        }
    }
}
