<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   LICENSE.txt
 */

use PrestaShop\Module\ProductPriceBySize\Factory\CartServiceFactory;

if (!defined('_PS_VERSION_')) {
    exit;
}

class Cart extends CartCore
{
    public function getTotalWeight($products = null)
    {
        $module = Module::getInstanceByName('productpricebysize');
        if (!Module::isEnabled('ProductPriceBySize')) {
            return parent::getTotalWeight($products);
        }

        try {
            $cartService = CartServiceFactory::getByModule($module, Context::getContext());
        } catch (Exception $e) {
            return parent::getTotalWeight($products);
        }

        if (!is_null($products)) {
            $cartService->getTotalWeight($products, $this->id, true);
        }

        return parent::getTotalWeight($products);
    }
}
