<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

if (!defined('_PS_VERSION_')) {
    exit;
}

class CartController extends CartControllerCore
{
    /**
     * Create customization before adding to cart, so id_customization can be assigned to cart product
     */
    protected function processChangeProductInCart()
    {
        $module = Module::getInstanceByName('productpricebysize');
        $idProduct = Tools::getValue('id_product');
        $idLang = Context::getContext()->language->id;
        $product = new Product($idProduct, false, $idLang);
        $mode = (Tools::getIsset('update') && $this->id_product) ? 'update' : 'add';
        $errorKey = ('update' === $mode) ? 'updateOperationError' : 'errors';

        if (Module::isEnabled('productpricebysize')) {
            $cartController = PrestaShop\Module\ProductPriceBySize\Factory\CartControllerFactory::getByModule('productpricebysize');
            $this->customization_id = $cartController->processChangeProductInCart($this->customization_id);

            if (!$cartController->processChangeProductInCartInStock()) {
                $this->{$errorKey}[] = $this->trans(
                    'The item %product% in your cart is no longer available in this quantity.',
                    ['%product%' => $product->name],
                    'Shop.Notifications.Error'
                );

                return false;
            }
        }
        parent::processChangeProductInCart();
    }
}
