<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin;

use PrestaShop\Module\ProductPriceBySize\Controller\Admin\Config\BaseController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

if (!defined('_PS_VERSION_')) {
    exit;
}

class AjaxController extends BaseController
{
    public function indexAction(Request $request): JsonResponse
    {
        $productRepository = $this->get('prestashop.module.productpricebysize.repository.product_repository');
        $idCategory = (int) $request->request->get('id_category');
        $products = $productRepository->getProductsByCategory($idCategory, \Context::getContext()->language->id);

        return new JsonResponse($products);
    }
}
