<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Config;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;

class BaseController extends FrameworkBundleAdminController
{
    protected function renderHeaderTabs(string $activeTabId): string
    {
        $tabs = [
            'tab_admin_config_dimensions' => [
                'id' => 'tab_admin_config_dimensions',
                'title' => $this->trans('Dimensions', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_config_dimensions'),
                'notification_count' => 0,
            ],
            'tab_admin_config_unit' => [
                'id' => 'tab_admin_config_unit',
                'title' => $this->trans('Units', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_config_unit'),
                'notification_count' => 0,
            ],
            'tab_admin_config_wastage' => [
                'id' => 'tab_admin_config_wastage',
                'title' => $this->trans('Wastage', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_config_wastage'),
                'notification_count' => 0,
            ],
            'tab_admin_config_equation_templates' => [
                'id' => 'tab_admin_config_equation_templates',
                'title' => $this->trans('Equation Templates', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_config_equation_templates'),
                'notification_count' => 0,
            ],
            'tab_admin_config_mass_assign' => [
                'id' => 'tab_admin_config_mass_assign',
                'title' => $this->trans('Mass Assign', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_config_mass_assign'),
                'notification_count' => 0,
            ],
        ];

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/tabs.html.twig',
            [
                'tabs' => $tabs,
                'active_tab_id' => $activeTabId,
            ]
        )->getContent();
    }
}
