<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Config;

use PrestaShop\Module\ProductPriceBySize\Grid\Filters\DimensionFilters;
use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class EquationTemplatesController extends BaseController
{
    public function indexAction(DimensionFilters $filters, Request $request): Response
    {
        $gridFactory = $this->get('productpricebysize.grid.factory.equation_template');
        $grid = $gridFactory->getGrid($filters);

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/config/equation_templates/index.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Equation Templates', 'Modules.Productpricebysize.Admin'),
                'layoutHeaderToolbarBtn' => [
                    'add' => [
                        'class' => 'btn-primary btn-group-add',
                        'href' => $this->generateUrl('productpricebysize_admin_config_equation_templates_new', ['id_equation_template' => 0]),
                        'desc' => $this->trans('New Equation Template', 'Modules.Productpricebysize.Admin'),
                        'icon' => 'add_circle_outline',
                    ],
                ],
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_config_equation_templates'),
                'grid' => $this->presentGrid($grid),
            ]
        );
    }

    public function editAction(Request $request): Response
    {
        $equationEditorPresenter = $this->get('prestashop.module.productpricebysize.presenter.admin.vue.component.equation_editor_presenter');
        $this->get('prestashop.module.productpricebysize.form.config.equation_template.data_provider')->setId((int) $request->get('id_equation_template'));
        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.config.equation_template.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            return $this->processAction($request, $form, $formDataHandler);
        }

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/config/equation_templates/edit.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Edit Equation Template', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_config_equation_templates'),
                'equationVariables' => $equationEditorPresenter->present(),
                'form' => $form->createView(),
            ]
        );
    }

    public function processAction(Request $request, Form $form, FormHandlerInterface $formDataHandler): Response
    {
        $data = $form->getData();
        try {
            $result = $formDataHandler->save($data);
            $this->addFlash('success', $this->trans('Equation Template Created', 'Modules.Productpricebysize.Admin'));
        } catch (\Exception $e) {
            $this->addFlash('error', $this->trans('Error saving equation template', 'Modules.Productpricebysize.Admin'));
        }

        return $this->redirectToRoute('productpricebysize_admin_config_equation_templates');
    }

    public function deleteAction(Request $request): Response
    {
        $idEquationTemplate = (int) $request->get('id_equation_template');
        if (empty($idEquationTemplate)) {
            $this->addFlash('error', $this->trans('Invalid Identifier provided', 'Modules.Productpricebysize.Admin'));
        } else {
            $this->addFlash('error', $this->trans('Equation Templated deleted', 'Modules.Productpricebysize.Admin'));
            $dataProvider = $this->get('prestashop.module.productpricebysize.form.config.equation_template.data_provider')->setId($idEquationTemplate);
            $dataProvider->delete();
        }

        return $this->redirectToRoute('productpricebysize_admin_config_equation_templates');
    }
}
