<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Config;

use PrestaShop\Module\ProductPriceBySize\Grid\Filters\DimensionFilters;
use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class MassAssignController extends BaseController
{
    public function indexAction(DimensionFilters $filters, Request $request): Response
    {
        $this->get('prestashop.module.productpricebysize.form.config.mass_assign.data_provider');
        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.config.mass_assign.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        $routes = [
            'admin_orders_products_search' => $this->get('router')->generate('admin_orders_products_search'),
            'productpricebysize_admin_ajax' => $this->get('router')->generate('productpricebysize_admin_ajax'),
        ];

        if ($form->isSubmitted()) {
            return $this->processAction($request, $form, $formDataHandler);
        }

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/config/mass_assign/index.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Mass Assign', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_config_mass_assign'),
                'form' => $form->createView(),
                'routes' => $routes,
            ]
        );
    }

    public function processAction(Request $request, Form $form, FormHandlerInterface $formDataHandler): Response
    {
        $data = $form->getData();
        try {
            $result = $formDataHandler->save($data);
            $this->addFlash('success', $this->trans('Mass Assign completed', 'Modules.Productpricebysize.Admin'));
        } catch (\Exception $e) {
            $this->addFlash('error', $this->trans('Error performing mass assign', 'Modules.Productpricebysize.Admin'));
        }

        return $this->redirectToRoute('productpricebysize_admin_config_mass_assign');

    }
}
