<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Config;

use PrestaShop\Module\ProductPriceBySize\Grid\Filters\UnitFilters;
use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class UnitController extends BaseController
{
    public function indexAction(UnitFilters $filters, Request $request): Response
    {
        $gridFactory = $this->get('productpricebysize.grid.factory.unit');
        $grid = $gridFactory->getGrid($filters);

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/config/unit/list.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Units', 'Modules.Productpricebysize.Admin'),
                'layoutHeaderToolbarBtn' => [
                    'add' => [
                        'class' => 'btn-primary btn-group-add',
                        'href' => $this->generateUrl('productpricebysize_admin_config_unit_new', ['id_unit' => 0]),
                        'desc' => $this->trans('New Unit', 'Modules.Productpricebysize.Admin'),
                        'icon' => 'add_circle_outline',
                    ],
                ],
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_config_unit'),
                'grid' => $this->presentGrid($grid),
            ]
        );
    }

    public function editAction(Request $request): Response
    {
        $this->get('prestashop.module.productpricebysize.form.config.unit.data_provider')->setId((int) $request->get('id_unit'));
        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.config.unit.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            return $this->processAction($request, $formDataHandler);
        }

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/config/unit/edit.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Unit Configuration', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabs('tab_unit'),
                'form' => $form->createView(),
            ]
        );
    }

    public function processAction(Request $request, FormHandlerInterface $formDataHandler): Response
    {
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);
        $data = $form->getData();

        if (empty($data['name'])) {
            $this->addFlash('error', $this->trans('Please enter a name for the unit', 'Modules.Productpricebysize.Admin'));
        } else {
            $this->addFlash('success', $this->trans('Unit saved successfully', 'Modules.Productpricebysize.Admin'));
        }
        $formDataHandler->save($data);

        return $this->redirectToRoute('productpricebysize_admin_config_unit');
    }

    public function deleteAction(Request $request): Response
    {
        $idUnit = (int) $request->get('id_unit');
        if (empty($idUnit)) {
            $this->addFlash('error', $this->trans('Invalid Dimension Identifier provided', 'Modules.Productpricebysize.Admin'));
        } else {
            $dataProvider = $this->get('prestashop.module.productpricebysize.form.config.unit.data_provider')->setId($idUnit);
            $dataProvider->delete();
        }

        return $this->redirectToRoute('productpricebysize_admin_config_unit');
    }
}
