<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Config;

use PrestaShop\Module\ProductPriceBySize\Grid\Filters\WastageFilters;
use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class WastageController extends BaseController
{
    public function indexAction(WastageFilters $filters, Request $request): Response
    {
        $gridFactory = $this->get('productpricebysize.grid.factory.wastage');
        $grid = $gridFactory->getGrid($filters);

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/global/list.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Wastage Options', 'Modules.Productpricebysize.Admin'),
                'layoutHeaderToolbarBtn' => [
                    'add' => [
                        'class' => 'btn-primary btn-group-add',
                        'href' => $this->generateUrl('productpricebysize_admin_config_wastage_new', ['id_wastage' => 0]),
                        'desc' => $this->trans('New Wastage', 'Modules.Productpricebysize.Admin'),
                        'icon' => 'add_circle_outline',
                    ],
                ],
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_config_wastage'),
                'grid' => $this->presentGrid($grid),
            ]
        );
    }

    public function editAction(Request $request): Response
    {
        $this->get('prestashop.module.productpricebysize.form.config.wastage.data_provider')->setId((int) $request->get('id_wastage'));
        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.config.wastage.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            return $this->processAction($request, $formDataHandler);
        }

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/global/edit.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Wastage Option Configuration', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_config_wastage'),
                'form' => $form->createView(),
            ]
        );
    }

    public function processAction(Request $request, FormHandlerInterface $formDataHandler): Response
    {
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);
        $data = $form->getData();
        $this->addFlash('success', $this->trans('Wastage Option saved successfully', 'Modules.Productpricebysize.Admin'));
        $formDataHandler->save($data);

        return $this->redirectToRoute('productpricebysize_admin_config_wastage');
    }

    public function deleteAction(Request $request): Response
    {
        $idWastage = (int) $request->get('id_wastage');
        if (empty($idWastage)) {
            $this->addFlash('error', $this->trans('Invalid Identifier', 'Modules.Productpricebysize.Admin'));
        } else {
            $dataProvider = $this->get('prestashop.module.productpricebysize.form.config.wastage.data_provider')->setId($idWastage);
            $dataProvider->delete();
        }

        return $this->redirectToRoute('productpricebysize_admin_config_wastage');
    }
}
