<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Common;

use parallel\Error;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductFieldController extends FrameworkBundleAdminController
{
    private function redirectToProductFields(string $productType, int $idProduct, string $message): Response
    {
        $this->addFlash('success', $message);
        switch ($productType) {
            case 'pap':
                return $this->redirectToRoute('productpricebysize_admin_product_pap_product_field', ['id_product' => $idProduct]);
            case 'ppbs':
                return $this->redirectToRoute('productpricebysize_admin_product_ppbs_product_field', ['id_product' => $idProduct]);
            default:
                return $this->redirectToRoute('productpricebysize_admin_product_ppbs_product_field', ['id_product' => $idProduct]);
        }
    }

    public function deleteAction(Request $request): Response
    {
        $idProductField = (int) $request->get('id_product_field');
        if (empty($idProductField)) {
            $this->addFlash('error', $this->trans('Invalid Product Field Identifier provided', 'Modules.Productpricebysize.Admin'));
        } else {
            $dataProvider = $this->get('prestashop.module.productpricebysize.form.product.product_field.data_provider')->setId($idProductField);
            $result = $dataProvider->delete();
        }

        return $this->redirectToProductFields($result['type'], $result['idProduct'], $this->trans('Product Field deleted', 'Modules.Productpricebysize.Admin'));
    }

    public function processPositionAction(Request $request): Response
    {
        $idProduct = (int) $request->get('id_product');
        $positions = $request->request->get('positions');
        $dataProvider = $this->get('prestashop.module.productpricebysize.form.product.product_field.data_provider');
        $ppbsProduct = $dataProvider->updatePositions($positions, $idProduct);

        return $this->redirectToProductFields($ppbsProduct->getType(), $idProduct, $this->trans('Product Fields updated', 'Modules.Productpricebysize.Admin'));
    }

    public function deleteValueAction(Request $request): Response
    {
        $idProductFieldValue = (int) $request->get('id_product_field_value');
        if (empty($idProductFieldValue)) {
            // $this->addFlash('error', $this->trans('Invalid Product Field Value Identifier provided', 'Modules.Productpricebysize.Admin'));
            echo $this->trans('Invalid Product Field Value Identifier provided', 'Modules.Productpricebysize.Admin');
            exit;
        } else {
            $dataProvider = $this->get('prestashop.module.productpricebysize.form.product.product_field_value.data_provider')->setId($idProductFieldValue);
            $ppbsProductFieldValue = $dataProvider->delete();
            $this->addFlash('success', $this->trans('Product Field Value deleted', 'Modules.Productpricebysize.Admin'));
            switch ($ppbsProductFieldValue->getProductField()->getProduct()->getType()) {
                case 'pap':
                    return $this->redirectToRoute('productpricebysize_admin_product_pap_product_field_edit', ['id_product_field' => $ppbsProductFieldValue->getProductField()->getId()]);
                case 'ppbs':
                    return $this->redirectToRoute('productpricebysize_admin_product_ppbs_product_field_edit', ['id_product_field' => $ppbsProductFieldValue->getProductField()->getId()]);
                default:
                    return $this->redirectToRoute('productpricebysize_admin_product_ppbs_product_field', ['id_product_field' => $ppbsProductFieldValue->getProductField()->getId()]);
            }
        }
    }
}
