<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Common;

use parallel\Error;
use PrestaShop\Module\ProductPriceBySize\Grid\Filters\ProductFieldFilters;
use PrestaShop\Module\ProductPriceBySize\Grid\Filters\ProductFieldValueFilters;
use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

trait ProductFieldControllerTrait
{
    public function indexActionShared(ProductFieldFilters $filters,
        Request $request,
        string $activeTabId,
        string $routeAddField): Response
    {
        $idProduct = (int) $request->get('id_product');
        $gridFactory = $this->get('productpricebysize.grid.factory.product_field');
        $grid = $gridFactory->getGrid($filters);

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/global/list.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Fields', 'Modules.Productpricebysize.Admin'),
                'layoutHeaderToolbarBtn' => [
                    'add' => [
                        'class' => 'btn-primary btn-group-add',
                        'href' => $this->generateUrl($routeAddField, ['id_product' => $idProduct]),
                        'desc' => $this->trans('Assign Field', 'Modules.Productpricebysize.Admin'),
                        'icon' => 'add_circle_outline',
                    ],
                ],
                'headerTabContent' => $this->renderHeaderTabsFromTrait($idProduct),
                'grid' => $this->presentGrid($grid),
                'parentProduct' => $this->getParentProductInfo($idProduct),
            ]
        );
    }

    public function editActionShared(ProductFieldValueFilters $filters, Request $request): Response
    {
        $idProductField = (int) $request->get('id_product_field');
        $idProduct = (int) $request->get('id_product');

        $productRepository = $this->get('prestashop.module.productpricebysize.repository.product_field_repository');
        $productField = $productRepository->find($idProductField);

        if (empty($productField) && $idProduct == 0) {
            // @todo: show error and redirect to appropriateplace
            exit;
        }

        if (!empty($productField)) {
            $idProduct = $productField->getIdProduct();
        }

        $this->get('prestashop.module.productpricebysize.form.product.product_field.data_provider')
            ->setId((int) $request->get('id_product_field'))
            ->setIdProduct($idProduct);
        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.product.product_field.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        $this->get('prestashop.module.productpricebysize.form.product.product_field.data_provider')
            ->setId((int) $request->get('id_product_field'))
            ->setIdProduct($idProduct);
        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.product.product_field.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        // The product field values grid
        $gridFactory = $this->get('productpricebysize.grid.factory.product_field_value');
        $filters->addFilter([
            'id_product_field' => $idProductField,
            'id_lang' => \Context::getContext()->language->id,
        ]);
        $grid = $gridFactory->getGrid($filters);

        if ($form->isSubmitted()) {
            return $this->processAction($request, $form, $formDataHandler);
        }

        $fieldTypo = '';

        if (!empty($productField)) {
            $fieldTypo = $productField->getFieldType()->getName();
        }

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/global/field/edit.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Edit Product Field', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabsFromTrait($idProduct),
                'form' => $form->createView(),
                'grid' => $this->presentGrid($grid),
                'idProductField' => $idProductField,
                'fieldType' => $fieldTypo,
            ]
        );
    }

    public function editValueActionShared(ProductFieldValueFilters $filters, Request $request): Response
    {
        $idProduct = 0;
        $idProductFieldValue = (int) $request->get('id_product_field_value');
        $idProductField = (int) $request->get('id_product_field');
        $this->get('prestashop.module.productpricebysize.form.product.product_field_value.data_provider')
            ->setId($idProductFieldValue)
            ->setIdProductField($idProductField);

        // Ge tProduct ID for the tab
        if (!empty($idProductField)) {
            $productFieldRepository = $this->get('prestashop.module.productpricebysize.repository.product_field_repository');
            $productField = $productFieldRepository->find($idProductField);
            $idProduct = $productField->getIdProduct();
        }

        if (!empty($idProductFieldValue)) {
            $productFieldValueRepository = $this->get('prestashop.module.productpricebysize.repository.product_field_value_repository');
            $productFieldValue = $productFieldValueRepository->find($idProductFieldValue);
            $idProduct = $productFieldValue->getProductField()->getIdProduct();
        }

        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.product.product_field_value.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);
        if ($form->isSubmitted()) {
            return $this->processValueAction($request, $form, $formDataHandler);
        }

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/global/edit.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Edit Product Field Value', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_product_ppbs_product_field', $idProduct),
                'form' => $form->createView(),
            ]
        );
    }

    public function processValueAction(Request $request, Form $form, FormHandlerInterface $formDataHandler): Response
    {
        $result = [];
        $data = $form->getData();
        try {
            $ppbsProductFieldValue = $formDataHandler->save($data);
            $this->addFlash('success', $this->trans('Field Value saved successfully', 'Modules.Productpricebysize.Admin'));
        } catch (\Exception $e) {
            exit($this->trans('Unable to save field value', 'Modules.Productpricebysize.Admin'));
        }

        return $this->redirectToRoute($this->routes['processEditValue'], ['id_product_field' => $ppbsProductFieldValue->getProductField()->getId()]);
    }
}
