<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Pap;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\Module\ProductPriceBySize\Service\ProductService;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;

class BaseController extends FrameworkBundleAdminController
{
    protected function renderHeaderTabs(string $activeTabId, int $idProduct): string
    {
        $tabs = [
            'tab_admin_product_pap_options' => [
                'id' => 'tab_admin_product_pap_options',
                'title' => $this->trans('Options', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_pap_options', ['id_product' => $idProduct, 'pack_type' => 'normal']),
                'notification_count' => 0,
            ],
            'tab_admin_product_pap_product_field' => [
                'id' => 'tab_admin_product_pap_product_field',
                'title' => $this->trans('Fields', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_pap_product_field', ['id_product' => $idProduct]),
                'notification_count' => 0,
            ],
            'tab_admin_product_pap_combinations' => [
                'id' => 'tab_admin_product_pap_combinations',
                'title' => $this->trans('Combinations', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_pap_combinations', ['id_product' => $idProduct, 'id_product_attribute' => 0]),
                'notification_count' => 0,
            ],
        ];

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/tabs.html.twig',
            [
                'tabs' => $tabs,
                'active_tab_id' => $activeTabId,
            ]
        )->getContent();
    }

    protected function getParentProductInfo(int $idProduct): array
    {
        return ProductService::getParentProductInfo($idProduct);
    }
}
