<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Pap;

use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class CombinationsController extends BaseController
{
    public function indexAction(Request $request): Response
    {
        $idProduct = (int) $request->get('id_product');
        $idProductAttribute = (int) $request->get('id_product_attribute');
        $productService = $this->get('prestashop.module.productpricebysize.factory.product_service');
        $productRepository = $this->get('prestashop.module.productpricebysize.repository.product_repository');

        $this->get('prestashop.module.productpricebysize.form.product.pap.combinations.data_provider')
            ->setIdProduct($idProduct)
            ->setIdProductAttribute($idProductAttribute);

        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.product.pap.combinations.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            return $this->processAction($request, $form, $formDataHandler);
        }

        $ppbsProduct = $productRepository->find($idProduct);

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/product/pap/options/combinations.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('Combination Options', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_product_pap_combinations', $idProduct),
                'attributes' => $productService->getAttributes($idProduct),
                'idProduct' => $idProduct,
                'idProductAttribute' => $idProductAttribute,
                'form' => $form->createView(),
                'ppbsProduct' => $ppbsProduct,
            ]
        );
    }

    public function processAction(Request $request, Form $form, FormHandlerInterface $formDataHandler): Response
    {
        $data = $form->getData();
        $formDataHandler->save($data);
        $this->addFlash('success', $this->trans('Settings for combination updated', 'Modules.Productpricebysize.Admin'));

        return $this->redirectToRoute('productpricebysize_admin_product_pap_combinations', [
            'id_product' => $data['id_product'],
            'id_product_attribute' => (int) $data['id_product_attribute'],
        ]);
    }
}
