<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Pap;

use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class OptionsController extends BaseController
{
    public function indexAction(Request $request): Response
    {
        $idProduct = (int) $request->get('id_product');
        $this->get('prestashop.module.productpricebysize.form.product.pap.options.data_provider')
            ->setIdProduct($idProduct);

        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.product.pap.options.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            return $this->processAction($request, $form, $formDataHandler);
        }

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/product/pap/options/index.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('General Options', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_product_pap_options', $idProduct),
                'form' => $form->createView(),
                'parentProduct' => $this->getParentProductInfo($idProduct),
            ]
        );
    }

    public function processAction(Request $request, Form $form, FormHandlerInterface $formDataHandler): Response
    {
        $data = $form->getData();
        $formDataHandler->save($data);
        $this->addFlash('success', $this->trans('Product Field saved successfully', 'Modules.Productpricebysize.Admin'));

        return $this->redirectToRoute('productpricebysize_admin_product_pap_options', [
            'id_product' => $data['id_product'],
            'pack_type' => 'normal',
        ]);
    }
}
