<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Pap;

use PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Common\ProductFieldControllerTrait;
use PrestaShop\Module\ProductPriceBySize\Grid\Filters\ProductFieldFilters;
use PrestaShop\Module\ProductPriceBySize\Grid\Filters\ProductFieldValueFilters;
use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductFieldController extends BaseController
{
    use ProductFieldControllerTrait;

    public $routes = [
        'processEditValue' => 'productpricebysize_admin_product_pap_product_field_edit',
    ];

    public function renderHeaderTabsFromTrait(int $idProduct): string
    {
        return parent::renderHeaderTabs('tab_admin_product_pap_product_field', $idProduct);
    }

    public function indexAction(ProductFieldFilters $filters, Request $request): Response
    {
        return $this->indexActionShared($filters, $request, 'tab_admin_product_pap_product_field', 'productpricebysize_admin_product_pap_product_field_new');
    }

    public function editAction(ProductFieldValueFilters $filters, Request $request): Response
    {
        return $this->editActionShared($filters, $request);
    }

    public function processAction(Request $request, Form $form, FormHandlerInterface $formDataHandler): Response
    {
        $data = $form->getData();
        $result = $formDataHandler->save($data);

        if ($result['fieldType'] == 'textbox' || (int) $data['id_product_field'] > 0) {
            $this->addFlash('success', $this->trans('Product Field saved successfully', 'Modules.Productpricebysize.Admin'));

            return $this->redirectToRoute('productpricebysize_admin_product_pap_product_field', ['id_product' => $result['idProduct']]);
        } elseif ($result['fieldType'] == 'dropdown' && (int) $data['id_product_field'] == 0) {
            $this->addFlash('success', $this->trans('Product Field saved successfully, scroll down to add value for the drop down', 'Modules.Productpricebysize.Admin'));

            return $this->redirectToRoute('productpricebysize_admin_product_pap_product_field_edit', ['id_product_field' => $result['idProductField']]);
        }

        return $this->redirectToRoute('productpricebysize_admin_product_pap_product_field_edit', ['id_product_field' => $result['idProductField']]);
    }

    public function editValueAction(ProductFieldValueFilters $filters, Request $request): Response
    {
        return $this->editValueActionShared($filters, $request);
    }

    public function deleteValueAction(Request $request): Response
    {
        $result = [];
        $idProductFieldValue = (int) $request->get('id_product_field_value');
        if (empty($idProductFieldValue)) {
            $this->addFlash('error', $this->trans('Invalid Product Field Value Identifier provided', 'Modules.Productpricebysize.Admin'));
        } else {
            $dataProvider = $this->get('prestashop.module.productpricebysize.form.product.product_field_value.data_provider')->setId($idProductFieldValue);
            $result = $dataProvider->delete();
            $this->addFlash('success', $this->trans('Product Field Value deleted', 'Modules.Productpricebysize.Admin'));
        }

        return $this->redirectToRoute('productpricebysize_admin_product_ppbs_product_field_edit', ['id_product_field' => $result['idProductField']]);
    }

    public function processValuePositionAction(Request $request): Response
    {
        $idProductField = (int) $request->get('id_product_field');
        $positions = $request->request->get('positions');
        $dataProvider = $this->get('prestashop.module.productpricebysize.form.product.product_field_value.data_provider');
        $dataProvider->updatePositions($positions);
        $this->addFlash('success', $this->trans('Product Field Value positions updated', 'Modules.Productpricebysize.Admin'));

        return $this->redirectToRoute('productpricebysize_admin_product_ppbs_product_field_edit', ['id_product_field' => $idProductField]);
    }
}
