<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Ppbs;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\Module\ProductPriceBySize\Service\ProductService;
use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;

class BaseController extends FrameworkBundleAdminController
{
    protected function renderHeaderTabs(string $activeTabId, int $idProduct): string
    {
        $tabs = [
            'tab_admin_product_ppbs_options' => [
                'id' => 'tab_admin_product_ppbs_options',
                'title' => $this->trans('Options', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_ppbs_options', ['id_product' => $idProduct]),
                'notification_count' => 0,
            ],
            'tab_admin_product_ppbs_product_field' => [
                'id' => 'tab_admin_product_ppbs_product_field',
                'title' => $this->trans('Fields', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_ppbs_product_field', ['id_product' => $idProduct]),
                'notification_count' => 0,
            ],
            'tab_admin_product_ppbs_area_price' => [
                'id' => 'tab_admin_product_ppbs_area_price',
                'title' => $this->trans('Area Based Prices', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_ppbs_area_price', ['id_product' => $idProduct]),
                'notification_count' => 0,
            ],
            'tab_admin_product_ppbs_price_equations' => [
                'id' => 'tab_admin_product_ppbs_price_equations',
                'title' => $this->trans('Price Equations', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_ppbs_price_equation', ['id_product' => $idProduct, 'id_product_attribute' => 0]),
                'notification_count' => 0,
            ],
            'tab_admin_product_ppbs_weight_equations' => [
                'id' => 'tab_admin_product_ppbs_weight_equations',
                'title' => $this->trans('Weight Equations', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_ppbs_weight_equation', ['id_product' => $idProduct, 'id_product_attribute' => 0]),
                'notification_count' => 0,
            ],
            'tab_admin_product_ppbs_stock' => [
                'id' => 'tab_admin_product_ppbs_stock',
                'title' => $this->trans('Area Stock', 'Modules.Productpricebysize.Admin'),
                'route' => $this->generateUrl('productpricebysize_admin_product_ppbs_stock', ['id_product' => $idProduct]),
                'notification_count' => 0,
            ],
        ];

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/tabs.html.twig',
            [
                'tabs' => $tabs,
                'active_tab_id' => $activeTabId,
            ]
        )->getContent();
    }

    protected function getParentProductInfo(int $idProduct): array
    {
        return ProductService::getParentProductInfo($idProduct);
    }
}
