<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Ppbs;

use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class BaseEquationsController extends BaseController
{
    protected $template = '';

    protected $layoutTitle = '';

    protected $headerTabContent = '';

    protected $equationType;

    public function indexAction(Request $request): Response
    {
        $idProduct = (int) $request->get('id_product');
        $idProductAttribute = (int) $request->get('id_product_attribute');
        $productService = $this->get('prestashop.module.productpricebysize.factory.product_service');
        $equationTemplateRepository = $this->get('prestashop.module.productpricebysize.repository.equation_template_repository');

        // The equation editor form
        $equationEditorPresenter = $this->get('prestashop.module.productpricebysize.presenter.admin.vue.component.equation_editor_presenter');
        $this->get('prestashop.module.productpricebysize.form.config.equation_template.data_provider')
            ->setId((int) $request->get('id_equation_template'))
            ->setIdProduct($idProduct)
            ->setIdProductAttribute($idProductAttribute)
            ->setSource('product')
            ->setIdEquationType($this->equationType);

        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.config.equation_template.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        $equationTemplates = $equationTemplateRepository->get(['isGlobal' => 1, 'idEquationType' => $this->equationType]);

        if ($form->isSubmitted()) {
            return $this->processAction($request, $form, $formDataHandler);
        }

        return $this->render(
            $this->template,
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->layoutTitle,
                'headerTabContent' => $this->headerTabContent,
                'idProduct' => $idProduct,
                'attributes' => $productService->getAttributes($idProduct),
                'equationVariables' => $equationEditorPresenter->present(),
                'form' => $form->createView(),
                'formData' => $form->getData(),
                'equationTemplates' => $equationTemplates,
                'parentProduct' => $this->getParentProductInfo($idProduct),
            ]
        );
    }

    public function save(Request $request, Form $form, FormHandlerInterface $formDataHandler): bool
    {
        $data = $form->getData();
        $result = $formDataHandler->save($data);

        return true;
    }
}
