<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Ppbs;

use PrestaShop\Module\ProductPriceBySize\Enum\EquationType;
use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class PriceEquationsController extends BaseEquationsController
{
    public function indexAction(Request $request): Response
    {
        $idProduct = (int) $request->get('id_product');
        $this->template = '@Modules/productpricebysize/views/templates/admin/product/ppbs/price_equations/index.html.twig';
        $this->layoutTitle = $this->trans('Price Equations', 'Modules.Productpricebysize.Admin');
        $this->headerTabContent = $this->renderHeaderTabs('tab_admin_product_ppbs_price_equations', $idProduct);
        $this->equationType = EquationType::getValue('price');

        return parent::indexAction($request);
    }

    public function processAction(Request $request, Form $form, FormHandlerInterface $formDataHandler): Response
    {
        $idProduct = (int) $request->get('id_product');
        $idProductAttribute = (int) $request->get('id_product_attribute');
        $this->save($request, $form, $formDataHandler);
        $this->addFlash('success', $this->trans('Product Weight Equation saved successfully', 'Modules.Productpricebysize.Admin'));

        return $this->redirectToRoute('productpricebysize_admin_product_ppbs_price_equation', [
            'id_product' => $idProduct,
            'id_product_attribute' => $idProductAttribute,
        ]);
    }

    public function deleteAction(Request $request): Response
    {
        $idProduct = (int) $request->get('id_product');
        $idProductAttribute = (int) $request->get('id_product_attribute');
        $dataProvider = $this->get('prestashop.module.productpricebysize.form.config.equation_template.data_provider');
        $dataProvider->deleteByProduct($idProduct, $idProductAttribute, EquationType::getValue('price'));
        $this->addFlash('success', $this->trans('Product Equation removed', 'Modules.Productpricebysize.Admin'));

        return $this->redirectToRoute('productpricebysize_admin_product_ppbs_price_equation', [
            'id_product' => $idProduct,
            'id_product_attribute' => $idProductAttribute,
        ]);
    }
}
