<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product\Ppbs;

use PrestaShop\PrestaShop\Core\Form\FormHandlerInterface;
use Symfony\Component\Form\Form;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

if (!defined('_PS_VERSION_')) {
    exit;
}

class StockController extends BaseController
{
    public function indexAction(Request $request): Response
    {
        $idProduct = (int) $request->get('id_product');
        $stockRepository = $this->get('prestashop.module.productpricebysize.repository.stock_repository');
        $productService = $this->get('prestashop.module.productpricebysize.factory.product_service');
        $attributes = $productService->getAttributes($idProduct);
        $stockLevels = $stockRepository->getByProduct($idProduct, \Context::getContext()->shop->id);

        foreach ($attributes as &$attribute) {
            $attribute['stock'] = 0;
            foreach ($stockLevels as $stockLevel) {
                if ($stockLevel['idProductAttribute'] == $attribute['id_product_attribute']) {
                    $attribute['stock'] = $stockLevel['stock'];
                }
            }
        }

        $this->get('prestashop.module.productpricebysize.form.product.ppbs.stock.data_provider')
            ->setIdProduct($idProduct)
            ->setIdShop(\Context::getContext()->shop->id);

        $formDataHandler = $this->get('prestashop.module.productpricebysize.form.product.ppbs.stock.data_handler');
        $form = $formDataHandler->getForm();
        $form->handleRequest($request);

        if ($form->isSubmitted()) {
            return $this->processAction($request, $form, $formDataHandler);
        }

        return $this->render(
            '@Modules/productpricebysize/views/templates/admin/product/ppbs/stock.html.twig',
            [
                'enableSidebar' => true,
                'showContentHeader' => true,
                'layoutTitle' => $this->trans('General Options', 'Modules.Productpricebysize.Admin'),
                'headerTabContent' => $this->renderHeaderTabs('tab_admin_product_ppbs_stock', $idProduct),
                'attributes' => $attributes,
                'form' => $form->createView(),
                'parentProduct' => $this->getParentProductInfo($idProduct),
            ]
        );
    }

    public function processAction(Request $request, Form $form, FormHandlerInterface $formDataHandler): Response
    {
        $data = $form->getData();
        $formDataHandler->save($data);
        $this->addFlash('success', $this->trans('Area Stock updated successfully', 'Modules.Productpricebysize.Admin'));

        return $this->redirectToRoute('productpricebysize_admin_product_ppbs_stock', ['id_product' => $data['id_product']]);
    }
}
