<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Controller\Admin\Product;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShopBundle\Controller\Admin\FrameworkBundleAdminController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

class ProductTabController extends FrameworkBundleAdminController
{
    private $module;

    private $productRepository;

    public function setMedia()
    {
    }

    public function clearProductSettings(int $idProduct)
    {
        $service = $this->get('prestashop.module.productpricebysize.admin.product_delete_service');
        $service->deleteSettings($idProduct);
    }

    public function ajaxAction(Request $request): JsonResponse
    {
        $data = json_decode($request->getContent(), true);
        $action = $data['action'];
        $idProduct = (int) $data['idProduct'];

        switch ($action) {
            case 'clearProductSettings':
                $this->clearProductSettings($idProduct);

                return new JsonResponse(['success' => '1']);
            default:
                return new JsonResponse(['error' => 'Invalid action']);
        }
    }
}
