<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Controller\Front\Pap;

use PrestaShop\Module\ProductPriceBySize\Controller\Front\Common\CoreController;
use PrestaShop\Module\ProductPriceBySize\Factory\ProductPresenterFactory;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductController extends CoreController
{
    public function getPackInfo(): string
    {
        $productPresenterFactory = new ProductPresenterFactory($this->moduleInstance->context, $this->moduleInstance);
        $idProduct = (int) \Tools::getValue('id_product');
        if (!empty(\Tools::getValue('group'))) {
            $idProductAttribute = \Product::getIdProductAttributeByIdAttributes((int) \Tools::getValue('id_product'), \Tools::getValue('group'));
        } else {
            $idProductAttribute = 0;
        }
        $presenter = $productPresenterFactory->get($idProduct);

        return json_encode($presenter->getPackInfo($idProduct, $idProductAttribute));
    }
}
