<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Controller\Front\Ppbs;

use PrestaShop\Module\ProductPriceBySize\Controller\Front\Common\CartControllerInterface;
use PrestaShop\Module\ProductPriceBySize\Controller\Front\Common\CoreController;

if (!defined('_PS_VERSION_')) {
    exit;
}

class CartController extends CoreController implements CartControllerInterface
{
    private $cartService;

    private $productRepository;

    private $cartRepository;

    private $stockRepository;

    public function __construct(\Module $moduleInstance, $params = [])
    {
        parent::__construct($moduleInstance, $params);
        $this->cartService = $this->moduleInstance->get('prestashop.module.productpricebysize.factory.ppbs_cart_service');
        $this->productRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.product_repository');
        $this->cartRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.cart_repository');
        $this->stockRepository = $this->moduleInstance->get('prestashop.module.productpricebysize.repository.stock_repository');
    }

    public function processChangeProductInCart(int $idCustomization): int
    {
        $idProduct = \Tools::getValue('id_product');
        $group = \Tools::getValue('group');
        $ipa = (int) \Tools::getValue('id_product_attribute');
        $qty = (int) \Tools::getValue('qty');
        $mode = (\Tools::getIsset('update') && $idProduct) ? 'update' : 'add';
        $formData = \Tools::getValue('ppbsFormData');
        if ($mode == 'add') {
            $idCustomization = $this->cartService->addToCart($idProduct, $idCustomization, $group, $ipa, $qty, $formData);
        }

        return $idCustomization;
    }

    public function processChangeProductInCartInStock()
    {
        $idCart = \Context::getContext()->cart->id;
        $idProduct = \Tools::getValue('id_product');
        $idProductAttribute = \Tools::getValue('id_product_attribute');
        $idCustomization = \Tools::getValue('id_customization');
        $idShop = \Context::getContext()->shop->id;
        $op = \Tools::getValue('op');
        $stockError = false;
        $mode = (\Tools::getIsset('update') && $idProduct) ? 'update' : 'add';
        $product = $this->productRepository->find($idProduct);

        if ($mode == 'update' && (int) \Tools::getValue('id_customization') > 0) {
            $ppbsStock = $this->stockRepository->get($idProduct, $idProductAttribute, $idShop);
            $productQuantity = $this->cartRepository->getProductQuantity($idProduct, $idProductAttribute, $idCustomization, $idCart);
            if ($op == 'up') {
                $productQuantity += (int) \Tools::getValue('qty');
            }
            if ($op == 'down') {
                $productQuantity -= (int) \Tools::getValue('qty');
                if ($productQuantity < 0) {
                    $productQuantity = 0;
                }
            }

            if ($product->getIsStockEnabled()) {
                $productInCartArea = $this->cartService->getProductTotalArea($idProduct, $idProductAttribute, $idCustomization, $idCart, $idShop);
                if (($productInCartArea * $productQuantity) > $ppbsStock) {
                    $stockError = true;
                }
            }

            if (!$stockError) {
                $this->cartRepository->setProductCustomizationQuantity($idProduct, $idProductAttribute, $idCustomization, $idCart, $productQuantity);
            }
        }

        return !$stockError;
    }

    public function hookDisplayProductPriceBlock(array $params): string
    {
        $shouldRender = false;
        $i = 0;
        foreach (debug_backtrace() as $debug) {
            if (strpos($debug['file'], 'cartmodal.tpl.php') > 0
                || strpos($debug['file'], 'cart-summary-product-line.tpl.php') > 0
                || strpos($debug['file'], 'cart-detailed-product-line.tpl') > 0
                || strpos($debug['file'], 'module.posshoppingcartmodal.tpl') > 0) {
                $shouldRender = true;
            }
            if ($i > 10) {
                break;
            }
            ++$i;
        }

        if (!$shouldRender || empty($params['product']['customizations'])) {
            return '';
        }

        $cartPresenter = $this->moduleInstance->get('prestashop.module.productpricebysize.presenter.front.cart_presenter');
        $customizations = $params['product']['customizations'];
        $optionsString = '';

        foreach ($customizations as $customization) {
            foreach ($customization['fields'] as $field) {
                if (!empty($field['text'])) {
                    $optionsString .= $cartPresenter->presentCustomizationString($field['text'], true) . '<br>';
                }
            }
        }

        $this->moduleInstance->smarty->assign([
            'optionsFormatted' => $optionsString,
        ]);

        return $this->moduleInstance->display($this->moduleInstance->moduleFile, 'views/templates/front/cart_modal_hook.tpl');
    }
}
