<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\AreaPriceRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=AreaPriceRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsAreaPrice
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_area_price", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idShop = 0;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idProduct = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $areaLow = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $areaHigh = 0;

    /**
     * @ORM\Column(type="string", length=6)
     */
    private ?string $impact = '';

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $price = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $weight = 0;

    /**
     * @ORM\ManyToOne(targetEntity=PpbsProduct::class, inversedBy="areaPrices")
     *
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id_product", nullable=false)
     */
    private ?PpbsProduct $product;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getIdShop(): int
    {
        return $this->idShop;
    }

    public function setIdShop(int $idShop): void
    {
        $this->idShop = $idShop;
    }

    public function getIdProduct(): int
    {
        return $this->idProduct;
    }

    public function setIdProduct(int $idProduct): void
    {
        $this->idProduct = $idProduct;
    }

    public function getAreaLow(): ?float
    {
        return $this->areaLow;
    }

    public function setAreaLow(float $areaLow): void
    {
        $this->areaLow = $areaLow;
    }

    public function getAreaHigh(): ?float
    {
        return $this->areaHigh;
    }

    public function setAreaHigh(float $areaHigh): void
    {
        $this->areaHigh = $areaHigh;
    }

    public function getImpact(): ?string
    {
        return $this->impact;
    }

    public function setImpact(string $impact): void
    {
        $this->impact = $impact;
    }

    public function getPrice(): ?float
    {
        return $this->price;
    }

    public function setPrice(float $price): void
    {
        $this->price = $price;
    }

    public function getWeight(): ?float
    {
        return $this->weight;
    }

    public function setWeight(float $weight): void
    {
        $this->weight = $weight;
    }

    public function getProduct(): ?PpbsProduct
    {
        return $this->product;
    }

    public function setProduct(PpbsProduct $product): void
    {
        $this->product = $product;
    }
}
