<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\DimensionRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=DimensionRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsDimensionLang
{
    /**
     * @ORM\Id
     *
     * @ORM\ManyToOne(targetEntity=PpbsDimension::class, inversedBy="dimensionLangs")
     *
     * @ORM\JoinColumn(name="id_dimension", referencedColumnName="id_dimension", nullable=false)
     */
    private ?PpbsDimension $dimension = null;

    /**
     * @ORM\Column(type="integer", length=128)
     */
    private ?int $idDimension = null;

    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", options={"unsigned": true})
     */
    private ?int $idLang = null;

    /**
     * @ORM\Column(type="string", length=128)
     */
    private string $displayName;

    /**
     * @ORM\Column(type="string", length=512)
     */
    private string $image;

    // Getters and setters
    public function getDimension(): PpbsDimension
    {
        return $this->dimension;
    }

    public function setDimension(PpbsDimension $dimension): self
    {
        $this->dimension = $dimension;

        return $this;
    }

    public function getIdDimension(): ?int
    {
        return $this->idDimension;
    }

    public function setIdDimension(int $idDimension): self
    {
        $this->idDimension = $idDimension;

        return $this;
    }

    public function getIdLang(): ?int
    {
        return $this->idLang;
    }

    public function setIdLang(int $idLang): self
    {
        $this->idLang = $idLang;

        return $this;
    }

    public function getDisplayName(): string
    {
        return $this->displayName;
    }

    public function setDisplayName(string $displayName): self
    {
        $this->displayName = $displayName;

        return $this;
    }

    public function getImage(): string
    {
        return $this->image;
    }

    public function setImage(string $image): self
    {
        $this->image = $image;

        return $this;
    }
}
