<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\EquationTemplateRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=EquationTemplateRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsEquationTemplate
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_equation_template", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\Column(type="string", length=64)
     */
    private ?string $name;

    /**
     * @ORM\Column(type="string", length=64)
     */
    private ?string $equation;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $isGlobal = false;

    /**
     * @ORM\Column(type="integer")
     */
    private ?int $idEquationType;

    /**
     * @ORM\OneToOne(targetEntity="PpbsEquationType")
     *
     * @ORM\JoinColumn(name="id_equation_type", referencedColumnName="id_equation_type", nullable=false)
     */
    private ?PpbsEquationType $equationType = null;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(?string $name): void
    {
        $this->name = $name;
    }

    public function getEquation(): string
    {
        return $this->equation;
    }

    public function setEquation(string $equation): void
    {
        $this->equation = $equation;
    }

    public function getIsGlobal(): bool
    {
        return $this->isGlobal;
    }

    public function setIsGlobal(bool $isGlobal): void
    {
        $this->isGlobal = $isGlobal;
    }

    public function getEquationType(): ?PpbsEquationType
    {
        return $this->equationType;
    }

    public function setEquationType(PpbsEquationType $equationType): void
    {
        $this->equationType = $equationType;
    }

    public function getIdEquationType(): ?int
    {
        return $this->idEquationType;
    }

    public function setIdEquationType(int $idEquationType): void
    {
        $this->idEquationType = $idEquationType;
    }
}
