<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=ProductRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsProduct
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_product", type="integer")
     */
    private ?int $id = null;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $isEnabled = false;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idUnit = 0;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $isFrontConversionEnabled = false;

    /**
     * @ORM\Column(type="string", length=3)
     */
    private ?string $frontConversionOperator = '';

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $frontConversionValue = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $minTotalArea = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $minPrice = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $setupFee = 0;

    /**
     * @ORM\Column(type="string", length=12)
     */
    private string $type;

    /**
     * @ORM\Column(type="string", length=12)
     */
    private ?string $papType;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $isDynamicPrice = false;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $isAttributePriceAreaPrice = false;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $isStockEnabled = false;

    /**
     * @ORM\OneToOne(targetEntity=PpbsUnit::class)
     *
     * @ORM\JoinColumn(name="id_unit", referencedColumnName="id_unit", nullable=false)
     */
    private PpbsUnit $unit;

    /**
     * @ORM\OneToMany(targetEntity=PpbsProductPack::class, mappedBy="product", cascade={"persist", "remove"})
     */
    private Collection $productPacks;

    /**
     * @ORM\OneToMany(targetEntity=PpbsAreaPrice::class, cascade={"persist", "remove"}, mappedBy="product")
     */
    private Collection $areaPrices;

    /**
     * @ORM\OneToMany(targetEntity=PpbsProductUnit::class, cascade={"persist", "remove"}, mappedBy="product")
     */
    private Collection $productUnits;

    /**
     * @ORM\OneToMany(targetEntity=PpbsProductWastage::class, cascade={"persist", "remove"}, mappedBy="product")
     */
    private Collection $wastageOptions;

    /**
     * @ORM\OneToMany(targetEntity=PpbsProductField::class, cascade={"persist", "remove"}, mappedBy="product")
     */
    private Collection $productFields;

    public function __construct()
    {
        $this->areaPrices = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getIsEnabled(): bool
    {
        return $this->isEnabled;
    }

    public function setIsEnabled(bool $isEnabled): void
    {
        $this->isEnabled = $isEnabled;
    }

    public function getType(): string
    {
        return $this->type;
    }

    public function setType(string $type): void
    {
        $this->type = $type;
    }

    public function getIsFrontConversionEnabled(): bool
    {
        return $this->isFrontConversionEnabled;
    }

    public function setIsFrontConversionEnabled(bool $isFrontConversionEnabled): void
    {
        $this->isFrontConversionEnabled = $isFrontConversionEnabled;
    }

    public function getFrontConversionOperator(): ?string
    {
        return $this->frontConversionOperator;
    }

    public function setFrontConversionOperator(?string $frontConversionOperator): void
    {
        $this->frontConversionOperator = $frontConversionOperator;
    }

    public function getFrontConversionValue(): float
    {
        return $this->frontConversionValue;
    }

    public function setFrontConversionValue(float $frontConversionValue): void
    {
        $this->frontConversionValue = $frontConversionValue;
    }

    public function getMinTotalArea(): float
    {
        return $this->minTotalArea;
    }

    public function setMinTotalArea(float $minTotalArea): void
    {
        $this->minTotalArea = $minTotalArea;
    }

    public function getIsAttributePriceAreaPrice(): bool
    {
        return $this->isAttributePriceAreaPrice;
    }

    public function setIsAttributePriceAreaPrice(bool $isAttributePriceAreaPrice): void
    {
        $this->isAttributePriceAreaPrice = $isAttributePriceAreaPrice;
    }

    public function getMinPrice(): float
    {
        return $this->minPrice;
    }

    public function setMinPrice(float $minPrice): void
    {
        $this->minPrice = $minPrice;
    }

    public function getSetupFee(): float
    {
        return $this->setupFee;
    }

    public function setSetupFee(float $setupFee): void
    {
        $this->setupFee = $setupFee;
    }

    public function getUnit(): PpbsUnit
    {
        return $this->unit;
    }

    public function setUnit(PpbsUnit $unit): void
    {
        $this->unit = $unit;
    }

    public function getAreaPrices(): Collection
    {
        return $this->areaPrices;
    }

    public function setAreaPrices(Collection $areaPrices): void
    {
        $this->areaPrices = $areaPrices;
    }

    public function getProductUnits(): Collection
    {
        return $this->productUnits;
    }

    public function setProductUnits(Collection $productUnits): void
    {
        $this->productUnits = $productUnits;
    }

    public function getIsStockEnabled(): bool
    {
        return $this->isStockEnabled;
    }

    public function setIsStockEnabled(bool $isStockEnabled): void
    {
        $this->isStockEnabled = $isStockEnabled;
    }

    public function getProductPacks(): Collection
    {
        return $this->productPacks;
    }

    public function setProductPacks(Collection $productPacks): void
    {
        $this->productPacks = $productPacks;
    }

    public function getWastageOptions(): Collection
    {
        return $this->wastageOptions;
    }

    public function setWastageOptions(Collection $wastageOptions): void
    {
        $this->wastageOptions = $wastageOptions;
    }

    public function getIdUnit(): int
    {
        return $this->idUnit;
    }

    public function setIdUnit(int $idUnit): void
    {
        $this->idUnit = $idUnit;
    }

    public function getProductFields(): Collection
    {
        return $this->productFields;
    }

    public function setProductFields(Collection $productFields): void
    {
        $this->productFields = $productFields;
    }

    public function getPapType(): ?string
    {
        return $this->papType;
    }

    public function setPapType(?string $papType): void
    {
        $this->papType = $papType;
    }

    public function getIsDynamicPrice(): bool
    {
        return $this->isDynamicPrice;
    }

    public function setIsDynamicPrice(bool $isDynamicPrice): void
    {
        $this->isDynamicPrice = $isDynamicPrice;
    }
}
