<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductEquationRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=ProductEquationRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsProductEquation
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_product_equation", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\ManyToOne(targetEntity="PpbsProduct")
     *
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id_product", nullable=false)
     */
    private ?PpbsProduct $product = null;

    /**
     * @ORM\ManyToOne(targetEntity="PpbsEquationTemplate")
     *
     * @ORM\JoinColumn(name="id_equation_template", referencedColumnName="id_equation_template", nullable=false)
     */
    private ?PpbsEquationTemplate $equationTemplate = null;

    /**
     * @ORM\Column(name="id_product", type="integer")
     */
    private int $idProduct;

    /**
     * @ORM\Column(name="id_product_attribute", type="integer")
     */
    private int $idProductAttribute;

    /**
     * @ORM\Column(name="id_equation_template", type="integer")
     */
    private int $idEquationTemplate;

    // Getters and Setters

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getProduct(): ?PpbsProduct
    {
        return $this->product;
    }

    public function setProduct(?PpbsProduct $product): self
    {
        $this->product = $product;

        return $this;
    }

    public function getEquationTemplate(): ?PpbsEquationTemplate
    {
        return $this->equationTemplate;
    }

    public function setEquationTemplate(?PpbsEquationTemplate $equationTemplate): self
    {
        $this->equationTemplate = $equationTemplate;

        return $this;
    }

    public function getIdProduct(): int
    {
        return $this->idProduct;
    }

    public function setIdProduct(int $idProduct): self
    {
        $this->idProduct = $idProduct;

        return $this;
    }

    public function getIdProductAttribute(): int
    {
        return $this->idProductAttribute;
    }

    public function setIdProductAttribute(int $idProductAttribute): self
    {
        $this->idProductAttribute = $idProductAttribute;

        return $this;
    }

    public function getIdEquationTemplate(): int
    {
        return $this->idEquationTemplate;
    }

    public function setIdEquationTemplate(int $idEquationTemplate): self
    {
        $this->idEquationTemplate = $idEquationTemplate;

        return $this;
    }
}
