<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductFieldRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=ProductFieldRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsProductField
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_product_field", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idProduct;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idUnit;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idFieldType;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idDimension;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private float $min;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private float $max;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $defaultValue;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $step;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private float $ratio;

    /**
     * @ORM\Column(type="integer")
     */
    private int $decimals;

    /**
     * @ORM\Column(type="integer")
     */
    private int $position;

    /**
     * @ORM\ManyToOne(targetEntity="PpbsProduct")
     *
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id_product", nullable=false)
     */
    private ?PpbsProduct $product = null;

    /**
     * @ORM\OneToOne(targetEntity="PpbsDimension")
     *
     * @ORM\JoinColumn(name="id_dimension", referencedColumnName="id_dimension", nullable=false)
     */
    private ?PpbsDimension $dimension = null;

    /**
     * @ORM\OneToOne(targetEntity="PpbsFieldType")
     *
     * @ORM\JoinColumn(name="id_field_type", referencedColumnName="id_field_type", nullable=false)
     */
    private ?PpbsFieldType $fieldType = null;

    /**
     * @ORM\OneToOne(targetEntity="PpbsUnit")
     *
     * @ORM\JoinColumn(name="id_unit", referencedColumnName="id_unit", nullable=false)
     */
    private ?PpbsUnit $unit = null;

    /**
     * @ORM\OneToMany(targetEntity=PpbsProductFieldValue::class, cascade={"persist", "remove"}, mappedBy="productField")
     */
    private ?Collection $values;

    public function setProduct(?PpbsProduct $product): void
    {
        $this->product = $product;
    }

    public function getProduct(): ?PpbsProduct
    {
        return $this->product;
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getIdProduct(): int
    {
        return $this->idProduct;
    }

    public function setIdProduct(int $idProduct): void
    {
        $this->idProduct = $idProduct;
    }

    public function getIdUnit(): int
    {
        return $this->idUnit;
    }

    public function setIdUnit(int $idUnit): void
    {
        $this->idUnit = $idUnit;
    }

    public function getIdFieldType(): int
    {
        return $this->idFieldType;
    }

    public function setIdFieldType(int $idFieldType): void
    {
        $this->idFieldType = $idFieldType;
    }

    public function getIdDimension(): int
    {
        return $this->idDimension;
    }

    public function setIdDimension(int $idDimension): void
    {
        $this->idDimension = $idDimension;
    }

    public function getDimension(): ?PpbsDimension
    {
        return $this->dimension;
    }

    public function setDimension(PpbsDimension $dimension): void
    {
        $this->dimension = $dimension;
    }

    public function getFieldType(): ?PpbsFieldType
    {
        return $this->fieldType;
    }

    public function setFieldType(PpbsFieldType $fieldType): void
    {
        $this->fieldType = $fieldType;
    }

    public function getUnit(): ?PpbsUnit
    {
        return $this->unit;
    }

    public function setUnit(PpbsUnit $unit): void
    {
        $this->unit = $unit;
    }

    public function getMin(): float
    {
        return $this->min;
    }

    public function setMin(float $min): void
    {
        $this->min = $min;
    }

    public function getMax(): float
    {
        return $this->max;
    }

    public function setMax(float $max): void
    {
        $this->max = $max;
    }

    public function getDefaultValue(): ?float
    {
        return $this->defaultValue;
    }

    public function setDefaultValue(?float $defaultValue): void
    {
        $this->defaultValue = $defaultValue;
    }

    public function getStep(): ?float
    {
        return $this->step;
    }

    public function setStep(?float $step): void
    {
        $this->step = $step;
    }

    public function getRatio(): float
    {
        return $this->ratio;
    }

    public function setRatio(float $ratio): void
    {
        $this->ratio = $ratio;
    }

    public function getDecimals(): int
    {
        return $this->decimals;
    }

    public function setDecimals(int $decimals): void
    {
        $this->decimals = $decimals;
    }

    public function getPosition(): int
    {
        return $this->position;
    }

    public function setPosition(int $position): void
    {
        $this->position = $position;
    }

    public function getValues(): Collection
    {
        return $this->values;
    }

    public function setValues(Collection $values): void
    {
        $this->values = $values;
    }
}
