<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductFieldValueRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=ProductFieldValueRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsProductFieldValue
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_product_field_value", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idProductField;

    /**
     * @ORM\ManyToOne(targetEntity="PpbsProductField")
     *
     * @ORM\JoinColumn(name="id_product_field", referencedColumnName="id_product_field", nullable=false)
     */
    private ?PpbsProductField $productField;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private float $value;

    /**
     * @ORM\Column(type="integer")
     */
    private $position;

    /**
     * @ORM\OneToMany(targetEntity=PpbsProductFieldValueLang::class, mappedBy="productFieldValue")
     */
    private Collection $langs;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getIdProductField(): int
    {
        return $this->idProductField;
    }

    public function setIdProductField(int $idProductField): void
    {
        $this->idProductField = $idProductField;
    }

    public function getProductField(): PpbsProductField
    {
        return $this->productField;
    }

    public function setProductField(PpbsProductField $productField): void
    {
        $this->productField = $productField;
    }

    public function getValue(): float
    {
        return $this->value;
    }

    public function setValue(float $value): void
    {
        $this->value = $value;
    }

    public function getPosition(): int
    {
        return $this->position;
    }

    public function setPosition(int $position): void
    {
        $this->position = $position;
    }

    public function getLangs(): Collection
    {
        return $this->langs;
    }

    public function setLangs(Collection $langs): void
    {
        $this->langs = $langs;
    }
}
