<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductFieldValueRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=ProductFieldValueRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsProductFieldValueLang
{
    /**
     * @ORM\Id
     *
     * @ORM\ManyToOne(targetEntity=PpbsProductFieldValue::class, inversedBy="dimensionLangs")
     *
     * @ORM\JoinColumn(name="id_product_field_value", referencedColumnName="id_product_field_value", nullable=false)
     */
    private ?PpbsProductFieldValue $productFieldValue = null;

    /**
     * @ORM\Column(type="integer")
     */
    private ?int $idProductFieldValue = null;

    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", options={"unsigned": true})
     */
    private ?int $idLang = null;

    /**
     * @ORM\Column(type="string", length=256)
     */
    private string $text;

    public function getProductFieldValue(): ?PpbsProductFieldValue
    {
        return $this->productFieldValue;
    }

    public function setProductFieldValue(PpbsProductFieldValue $productFieldValue): void
    {
        $this->productFieldValue = $productFieldValue;
    }

    public function getIdProductFieldValue(): ?int
    {
        return $this->idProductFieldValue;
    }

    public function setIdProductFieldValue(int $idProductFieldValue): void
    {
        $this->idProductFieldValue = $idProductFieldValue;
    }

    public function getIdLang(): ?int
    {
        return $this->idLang;
    }

    public function setIdLang(int $idLang): void
    {
        $this->idLang = $idLang;
    }

    public function getText(): string
    {
        return $this->text;
    }

    public function setText(string $text): void
    {
        $this->text = $text;
    }
}
