<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductPackRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=ProductPackRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsProductPack
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_product_pack", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\ManyToOne(targetEntity=PpbsProduct::class, inversedBy="ppbsProductPacks")
     *
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id_product", nullable=false)
     */
    private ?PpbsProduct $product = null;

    /**
     * @ORM\Column(type="integer")
     */
    private ?int $idProduct = 0;

    /**
     * @ORM\Column(type="integer")
     */
    private ?int $idProductAttribute = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $packArea = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $areaPrice = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $rollHeight = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $rollWidth = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $patternRepeat = 0;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private ?float $coverage = 0;

    public function __construct()
    {
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getProduct(): ?PpbsProduct
    {
        return $this->product;
    }

    public function setProduct(PpbsProduct $product): void
    {
        $this->product = $product;
    }

    public function getIdProductAttribute(): ?int
    {
        return $this->idProductAttribute;
    }

    public function setIdProductAttribute(int $idProductAttribute): void
    {
        $this->idProductAttribute = $idProductAttribute;
    }

    public function getPackArea(): ?float
    {
        return $this->packArea;
    }

    public function setPackArea(float $packArea): void
    {
        $this->packArea = $packArea;
    }

    public function getAreaPrice(): ?float
    {
        return $this->areaPrice;
    }

    public function setAreaPrice(float $areaPrice): void
    {
        $this->areaPrice = $areaPrice;
    }

    public function getRollHeight(): ?float
    {
        return $this->rollHeight;
    }

    public function setRollHeight(float $rollHeight): void
    {
        $this->rollHeight = $rollHeight;
    }

    public function getRollWidth(): float
    {
        return $this->rollWidth;
    }

    public function setRollWidth(float $rollWidth): void
    {
        $this->rollWidth = $rollWidth;
    }

    public function getPatternRepeat(): ?float
    {
        return $this->patternRepeat;
    }

    public function setPatternRepeat(float $patternRepeat): void
    {
        $this->patternRepeat = $patternRepeat;
    }

    public function getCoverage(): ?float
    {
        return $this->coverage;
    }

    public function setCoverage(float $coverage): void
    {
        $this->coverage = $coverage;
    }
}
