<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductUnitRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=ProductUnitRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsProductUnit
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_product_unit", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $isDefault = false;

    /**
     * @ORM\ManyToOne(targetEntity="PpbsProduct")
     *
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id_product", nullable=false)
     */
    private ?PpbsProduct $product = null;

    /**
     * @ORM\ManyToOne(targetEntity="PpbsUnit")
     *
     * @ORM\JoinColumn(name="id_unit", referencedColumnName="id_unit", nullable=false)
     */
    private ?PpbsUnit $unit = null;

    // Getters and Setters

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIsDefault(): bool
    {
        return $this->isDefault;
    }

    public function setIsDefault(bool $isDefault): void
    {
        $this->isDefault = $isDefault;
    }

    public function getProduct(): ?PpbsProduct
    {
        return $this->product;
    }

    public function setProduct(?PpbsProduct $product): void
    {
        $this->product = $product;
    }

    public function getUnit(): ?PpbsUnit
    {
        return $this->unit;
    }

    public function setUnit(?PpbsUnit $unit): void
    {
        $this->unit = $unit;
    }
}
