<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\ProductWastageRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=ProductWastageRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsProductWastage
{
    /**
     * @ORM\Column(name="id_product", type="integer")
     */
    private ?int $idProduct = null;

    /**
     * @ORM\Column(name="id_wastage", type="integer")
     */
    private ?int $idWastage = null;

    /**
     * @ORM\Id
     *
     * @ORM\ManyToOne(targetEntity="PpbsProduct")
     *
     * @ORM\JoinColumn(name="id_product", referencedColumnName="id_product", nullable=false)
     */
    private ?PpbsProduct $product = null;

    /**
     * @ORM\Id
     *
     * @ORM\ManyToOne(targetEntity="PpbsWastage")
     *
     * @ORM\JoinColumn(name="id_wastage", referencedColumnName="id_wastage", nullable=false)
     */
    private ?PpbsWastage $wastage = null;

    // Getters and Setters

    public function getIdProduct(): ?int
    {
        return $this->idProduct;
    }

    public function setIdProduct(?int $idProduct): void
    {
        $this->idProduct = $idProduct;
    }

    public function getIdWastage(): ?int
    {
        return $this->idWastage;
    }

    public function setIdWastage(int $idWastage): void
    {
        $this->idWastage = $idWastage;
    }

    public function getProduct(): ?PpbsProduct
    {
        return $this->product;
    }

    public function setProduct(?PpbsProduct $product): void
    {
        $this->product = $product;
    }

    public function getWastage(): ?PpbsWastage
    {
        return $this->wastage;
    }

    public function setWastage(?PpbsWastage $wastage): void
    {
        $this->wastage = $wastage;
    }
}
