<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\StockRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=StockRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsStock
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_stock", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idProduct;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idProductAttribute;

    /**
     * @ORM\Column(type="integer")
     */
    private int $idShop;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private float $stock;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getIdProduct(): int
    {
        return $this->idProduct;
    }

    public function setIdProduct(int $idProduct): void
    {
        $this->idProduct = $idProduct;
    }

    public function getIdProductAttribute(): int
    {
        return $this->idProductAttribute;
    }

    public function setIdProductAttribute(int $idProductAttribute): void
    {
        $this->idProductAttribute = $idProductAttribute;
    }

    public function getIdShop(): int
    {
        return $this->idShop;
    }

    public function setIdShop(int $idShop): void
    {
        $this->idShop = $idShop;
    }

    public function getStock(): float
    {
        return $this->stock;
    }

    public function setStock(float $stock): void
    {
        $this->stock = $stock;
    }
}
