<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\UnitRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=UnitRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsUnit
{
    /**
     * @ORM\Id
     *
     * @ORM\Column(name="id_unit", type="integer")
     *
     * @ORM\GeneratedValue(strategy="AUTO")
     */
    private ?int $id = null;

    /**
     * @ORM\Column(type="string", length=64)
     */
    private string $name;

    /**
     * @ORM\Column(type="decimal", precision=8, scale=2)
     */
    private float $conversionFactor;

    /**
     * @ORM\Column(type="boolean")
     */
    private bool $isDeleted = false;

    /**
     * @ORM\OneToMany(targetEntity=PpbsUnitLang::class, cascade={"persist", "remove"}, mappedBy="unit")
     */
    private Collection $langs;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function setId(int $id): void
    {
        $this->id = $id;
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function setName(string $name): void
    {
        $this->name = $name;
    }

    public function getConversionFactor(): float
    {
        return $this->conversionFactor;
    }

    public function setConversionFactor(float $conversionFactor): void
    {
        $this->conversionFactor = $conversionFactor;
    }

    public function getLangs(): Collection
    {
        return $this->langs;
    }

    public function setLangs(Collection $langs): void
    {
        $this->langs = $langs;
    }

    public function isDeleted(): bool
    {
        return $this->isDeleted;
    }

    public function setIsDeleted(bool $isDeleted): void
    {
        $this->isDeleted = $isDeleted;
    }
}
