<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Entity;

use Doctrine\ORM\Mapping as ORM;
use PrestaShop\Module\ProductPriceBySize\Repository\UnitRepository;

if (!defined('_PS_VERSION_')) {
    exit;
}

/**
 * @ORM\Entity(repositoryClass=UnitRepository::class)
 *
 * @ORM\HasLifecycleCallbacks
 */
class PpbsUnitLang
{
    /**
     * @ORM\Id
     *
     * @ORM\ManyToOne(targetEntity=PpbsUnit::class, inversedBy="unitLangs")
     *
     * @ORM\JoinColumn(name="id_unit", referencedColumnName="id_unit", nullable=false)
     */
    private ?PpbsUnit $unit = null;

    /**
     * @ORM\Column(type="integer", length=128)
     */
    private ?int $idUnit = null;

    /**
     * @ORM\Id
     *
     * @ORM\Column(type="integer", options={"unsigned": true})
     */
    private ?int $idLang = null;

    /**
     * @ORM\Column(type="string", length=128)
     */
    private string $displayName;

    // Getters and setters

    public function getUnit(): ?PpbsUnit
    {
        return $this->unit;
    }

    public function setUnit(PpbsUnit $unit): void
    {
        $this->unit = $unit;
    }

    public function getIdLang(): ?int
    {
        return $this->idLang;
    }

    public function setIdLang(int $idLang): void
    {
        $this->idLang = $idLang;
    }

    public function getDisplayName(): string
    {
        return $this->displayName;
    }

    public function setDisplayName(string $displayName): void
    {
        $this->displayName = $displayName;
    }

    public function getIdUnit(): ?int
    {
        return $this->idUnit;
    }

    public function setIdUnit(int $idUnit): void
    {
        $this->idUnit = $idUnit;
    }
}
