<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Enum;

if (!defined('_PS_VERSION_')) {
    exit;
}

class EquationType
{
    const PRICE = 'price';
    const WEIGHT = 'weight';

    public static function getValue(string $string): int
    {
        switch ($string) {
            case self::PRICE:
                return 1;
            case self::WEIGHT:
                return 2;
            default:
                throw new \InvalidArgumentException('Invalid value provided');
        }
    }
}
