<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Factory;

use PrestaShop\Module\ProductPriceBySize\Service\Common\AbstractCartService;

if (!defined('_PS_VERSION_')) {
    exit;
}

class CartServiceFactory
{
    public static function getByModule(\Module $module, \Context $context): ?AbstractCartService
    {
        switch ($module->name) {
            case 'productpricebysize':
                return new \PrestaShop\Module\ProductPriceBySize\Service\Ppbs\CartService($context, $module);
            default:
                throw new \Exception('Unknown product type');
        }
    }
}
