<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Factory;

use PrestaShop\Module\ProductPriceBySize\Service\Common\PriceServiceInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

class PriceServiceFactory
{
    private $context;

    private $module;

    public function __construct(\Context $context, \Module $module)
    {
        $this->context = $context;
        $this->module = $module;
    }

    public function get(int $idProduct): ?PriceServiceInterface
    {
        $repository = $this->module->get('prestashop.module.productpricebysize.repository.product_repository');
        $product = $repository->find($idProduct);

        if (empty($product)) {
            return null;
        }

        switch ($product->getType()) {
            case 'ppbs':
                return new \PrestaShop\Module\ProductPriceBySize\Service\Ppbs\PriceService($this->context, $this->module);
            case 'pap':
                return new \PrestaShop\Module\ProductPriceBySize\Service\Pap\PriceService($this->context, $this->module);
            default:
                throw new \Exception('Unknown product type');
        }
    }
}
