<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Factory;

use PrestaShop\Module\ProductPriceBySize\Presenter\Front\Common\AbstractProductPresenter;

if (!defined('_PS_VERSION_')) {
    exit;
}

class ProductPresenterFactory
{
    private $context;

    private $module;

    public function __construct(\Context $context, \Module $module)
    {
        $this->context = $context;
        $this->module = $module;
    }

    public function get(int $idProduct): ?AbstractProductPresenter
    {
        $repository = $this->module->get('prestashop.module.productpricebysize.repository.product_repository');
        $product = $repository->find($idProduct);
        if (empty($product)) {
            return null;
        }

        switch ($product->getType()) {
            case 'ppbs':
                return $this->module->get('prestashop.module.productpricebysize.presenter.front.ppbs.product_presenter');
            case 'pap':
                return $this->module->get('prestashop.module.productpricebysize.presenter.front.pap.product_presenter');
            default:
                throw new \Exception('Unknown product type when creating presenter');
        }
    }
}
