<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Form\ChoiceProvider;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\Module\ProductPriceBySize\Enum\CalculationType;
use PrestaShop\PrestaShop\Core\Form\FormChoiceProviderInterface;

/**
 * Class CategoryChoiceProvider.
 */
final class CalculationTypeChoiceProvider implements FormChoiceProviderInterface
{
    private $context;

    private $translator;

    public function __construct(\Context $context, $translator)
    {
        $this->context = $context;
        $this->translator = $translator;
    }

    public function getChoices(): array
    {
        return [
            $this->translator->trans('Individual Quantities', [], 'Modules.Productpricebysize.Admin') => CalculationType::NORMAL,
            $this->translator->trans('Dynamic Price based on Area', [], 'Modules.Productpricebysize.Admin') => CalculationType::DYNAMIC,
        ];
    }
}
