<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

namespace PrestaShop\Module\ProductPriceBySize\Form\ChoiceProvider;

if (!defined('_PS_VERSION_')) {
    exit;
}

use Doctrine\ORM\EntityManagerInterface;
use PrestaShop\Module\ProductPriceBySize\Repository\WastageRepository;
use PrestaShop\PrestaShop\Core\Form\FormChoiceProviderInterface;

/**
 * Class CategoryChoiceProvider.
 */
final class WastageChoiceProvider implements FormChoiceProviderInterface
{
    private $context;

    private $entityManager;

    private $wastageRepository;

    public function __construct(\Context $context,
        EntityManagerInterface $entityManager,
        WastageRepository $wastageRepository)
    {
        $this->context = $context;
        $this->entityManager = $entityManager;
        $this->wastageRepository = $wastageRepository;
    }

    public function getChoices(): array
    {
        $unitChoices = [];
        $options = $this->wastageRepository->findAll();
        foreach ($options as $option) {
            $unitChoices[$option->getValue()] = $option->getId();
        }

        return $unitChoices;
    }
}
