<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Config;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\PrestaShop\Core\ConstraintValidator\Constraints\DefaultLanguage;
use PrestaShopBundle\Form\Admin\Type\TranslatableType;
use PrestaShopBundle\Form\Admin\Type\TranslatorAwareType;
use Symfony\Component\Form\Extension\Core\Type\FileType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class DimensionFormType extends TranslatorAwareType
{
    protected $requestStack;

    public function __construct($translator,
        array $locales,
        RequestStack $requestStack) {
        parent::__construct($translator, $locales);
        $this->requestStack = $requestStack;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $languages = \Language::getLanguages();
        $builder
            ->add('id', HiddenType::class, [
                'required' => false,
            ])
            ->add('name', TextType::class, [
                'required' => true,
            ])
            ->add('display_name', TranslatableType::class, [
                'label' => $this->trans('Display Name', 'Modules.Productpricebysize.Admin', []),
                'required' => true,
                'constraints' => [
                    new DefaultLanguage(),
                ],
            ]);

        foreach ($languages as $lang) {
            $builder->add('image_' . $lang['id_lang'], FileType::class, [
                'required' => false,
                'label' => $this->trans('Hint Image for %lang%', 'Modules.Productpricebysize.Admin', ['%lang%' => $lang['name']]),
                'data_class' => null,
            ]);
        }
    }
}
