<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Config;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShopBundle\Form\Admin\Type\TranslatorAwareType;
use Symfony\Component\Form\Extension\Core\Type\ChoiceType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class EquationTemplateFormType extends TranslatorAwareType
{
    protected $requestStack;

    protected $equationTypeChoices;

    public function __construct($translator,
        array $locales,
        RequestStack $requestStack,
        array $equationTypeChoices) {
        parent::__construct($translator, $locales);
        $this->requestStack = $requestStack;
        $this->equationTypeChoices = $equationTypeChoices;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('id_equation_template', HiddenType::class, [
                'required' => false,
            ])
            ->add('id_product', HiddenType::class, [
                'required' => false,
            ])
            ->add('id_product_attribute', HiddenType::class, [
                'required' => false,
            ])
            ->add('id_equation_type', ChoiceType::class, [
                'label' => $this->trans('Equation Type', 'Modules.Productpricebysize.Admin'),
                'required' => true,
                'choices' => $this->equationTypeChoices,
            ])
            ->add('is_global', HiddenType::class, [
                'label' => $this->trans('Is Global', 'Modules.Productpricebysize.Admin'),
                'required' => false,
            ])
            ->add('name', TextType::class, [
                'required' => true,
            ])
            ->add('equation', HiddenType::class, [
                'required' => true,
            ])
            ->add('source', HiddenType::class, [
                'required' => false,
            ])
            ->add('save_method', HiddenType::class, [
                'required' => false,
            ]);
    }
}
