<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Config;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShop\Module\ProductPriceBySize\Service\Admin\MassAssignService;
use PrestaShop\Module\ProductPriceBySize\Service\Admin\ProductDeleteService;
use PrestaShop\PrestaShop\Core\Form\FormDataProviderInterface;

/**
 * Provider ir responsible for providing form data, in this case it's as simple as using configuration to do that
 */
class MassAssignFormDataProvider implements FormDataProviderInterface
{
    protected $context;

    protected $massAssignService;

    protected $productDeleteService;

    public function __construct(
        \Context $context,
        MassAssignService $massAssignService,
        ProductDeleteService $productDeleteService) {
        $this->context = $context;
        $this->massAssignService = $massAssignService;
        $this->productDeleteService = $productDeleteService;
    }

    public function getData(): array
    {
        return [];
    }

    public function setData(array $data): array
    {
        $idProductSource = (int) $data['id_product_source'];
        $idProductList = !empty($data['id_product_list']) ? $data['id_product_list'] : [];
        $idCategoryList = !empty($data['massassign_categories']) ? $data['massassign_categories'] : [];
        $idLang = (int) \Context::getContext()->language->id;

        $idProductList = empty($idProductList) ? [] : json_decode($idProductList, true);
        $idCategoryList = empty($idCategoryList) ? [] : $idCategoryList;

        if (!empty($idProductList)) {
            foreach ($idProductList as $idProductDestination) {
                $this->productDeleteService->deleteSettings((int) $idProductDestination);
                $this->massAssignService->duplicateProduct($idProductSource, (int) $idProductDestination);
            }
        } elseif (!empty($idCategoryList)) {
            foreach ($idCategoryList as $idCategory) {
                $products = $this->massAssignService->productRepository->getProductsByCategory((int) $idCategory, $idLang);
                foreach ($products as $product) {
                    if ($idProductSource != (int) $product['id_product']) {
                        $idProductDestination = (int) $product['id_product'];
                        $this->productDeleteService->deleteSettings($idProductDestination);
                        $this->massAssignService->duplicateProduct($idProductSource, $idProductDestination);
                    }
                }
            }
        }

        return [];
    }
}
