<?php
/**
 * NOTICE OF LICENSE
 *
 * This file is licenced under the Software License Agreement.
 * With the purchase or the installation of the software in your application
 * you accept the licence agreement.
 *
 * You must not modify, adapt or create derivative works of this source code
 *
 * @author    Musaffar Patel
 * @copyright 2016-2025 Musaffar Patel
 * @license   https://opensource.org/licenses/AFL-3.0 Academic Free License 3.0 (AFL-3.0)
 */

declare(strict_types=1);

namespace PrestaShop\Module\ProductPriceBySize\Form\Config;

if (!defined('_PS_VERSION_')) {
    exit;
}

use PrestaShopBundle\Form\Admin\Type\CategoryChoiceTreeType;
use PrestaShopBundle\Form\Admin\Type\TranslatorAwareType;
use Symfony\Component\Form\Extension\Core\Type\HiddenType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\HttpFoundation\RequestStack;

class MassAssignFormType extends TranslatorAwareType
{
    protected $requestStack;

    public function __construct($translator,
        array $locales,
        RequestStack $requestStack) {
        parent::__construct($translator, $locales);
        $this->requestStack = $requestStack;
    }

    /**
     * {@inheritdoc}
     */
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('id_product_source', HiddenType::class, [
                'required' => false,
            ])
            ->add('id_product_list', HiddenType::class, [
                'label' => '',
                'required' => false,
            ])
            ->add('massassign_categories', CategoryChoiceTreeType::class, [
                'label' => $this->trans('Select a category or categories', 'Module.Productpricebysize.Admin'),
                'help' => $this->trans('Select categories to copy to.  Select a single category to copy to multiple products in that category', 'Module.Productpricebysize.Admin'),
                'disabled_values' => [],
                'required' => false,
                'multiple' => true,
            ]);
    }
}
